/*!---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
/**
 * The results of a group of promises.
 * Each property is an array, whose elements correspond to the promise at the same index
 * passed to the tryAll function
 *
 * @export
 * @interface PromiseResults
 */
export interface PromiseResults {
    /**
     * Whether each promise resolved (true) or rejected (false)
     *
     * @type {boolean[]}
     */
    resolved: boolean[];
    /**
     * The value each promise resolved to, if it resolved.
     *
     * @type {any[]}
     */
    results: any[];
    /**
     * the reason each promise rejected, if it rejected.
     *
     * @type {any[]}
     */
    failReasons: any[];
}
/**
 * Given an array of promises, will return a promise that resolves when all the provided promises are settled.
 * The result of the promise is three arrays that tell the complete story
 * of what happened to each promise and its results:
 * One with the the results of resolved promises, one with the failure reasons of rejected Promises,
 * and one with a boolean indicating whether it resolved.
 * The indices of the three arrays correspond to the indices of the originally passed in promise.
 * This promise should never reject.
 */
export declare function tryAll<T>(input: Promise<T>[]): Promise<PromiseResults>;
